unit main_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask, JvExMask, JvToolEdit, ComCtrls, Spin, ExtCtrls,
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient, oxPerst,nExcel;

type

  EGeneralError = class(Exception);


  TForm1 = class(TForm)
    Label1: TLabel;
    JvFilenameEdit1: TJvFilenameEdit;
    Button1: TButton;
    StatusBar1: TStatusBar;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    Label3: TLabel;
    Timer1: TTimer;
    Label4: TLabel;
    Edit1: TEdit;
    TCP1: TIdTCPClient;
    oxPersist1: ToxPersist;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SendOutData(sign:Integer);
    procedure PollExcel;
  end;

var
  Form1: TForm1;
  LineLength:array[1..255] of Integer;
  LineCount:array[1..255] of Integer;
  LinePause:array[1..255] of Integer;
  LineAlign:array[1..255,1..99,1..4] of XlHAlign;
  LineData:array[1..255,1..99,1..4] of string;
  SignCount:Integer;
  CurrentSign:Integer;
  CurrentTicker:Integer;
  PollTicker:Integer;
  SignLen:Integer;


implementation

{$R *.dfm}


procedure TForm1.SendOutData(sign:Integer);
var
    s,sv: string;
    i,xl,xr,xs,col: Integer;
begin
    try
        SignLen:=6;  { fixed at 6 for this program }
        StatusBar1.Panels[1].Text:='Sending Data...';
        Application.ProcessMessages;
        TCP1.Host:=Trim(Edit1.Text);
        TCP1.Connect(3000);
        for i:=1 to LineCount[sign] do
        begin
            s:='';
            for col:=1 to 4 do
            begin
            sv:=LineData[sign,i,col];
            if sv='' then sv:=' ';
            xl:=Length(sv);
            xs:=xl;
            if xl>SignLen then
                sv:=Copy(sv,1,SignLen);
            xr:=(SignLen div 2) - (xl div 2);
            xl:=SignLen-xr-xl;
            case LineAlign[sign,i,col] of
            XlHAlignCenter:
                    sv:=StringOfChar(' ',xl)+sv+StringOfChar(' ',xr);
            XlHAlignLeft:
                    sv:=sv+StringOfChar(' ',SignLen-xs);
            else
                    sv:=StringOfChar(' ',SignLen-xs)+sv;
            end;
            s:=s+sv;
            end;
            s:=#2+Format('%2.2d',[i])+s+#3;
            TCP1.Write(s);
        end;
        TCP1.Disconnect;
        StatusBar1.Panels[1].Text:='Sending Data Complete.';
    except
        StatusBar1.Panels[1].Text:='Error sending data. Check IP.';
    end;
end;

procedure TForm1.PollExcel;
Var book: IXLSWorkbook;
    i,j,x,col:Integer;
begin
    StatusBar1.Panels[1].Text:='Polling workbook...';
    Application.ProcessMessages;
    SignCount:=0;
    try
        book := TXLSWorkbook.Create();
        book.Open(JvFileNameEdit1.FileName);
        SignCount:=book.WorkSheets.Count;
        if (SignCount<1) or (SignCount>255) then
            raise EGeneralError.Create('Could not open file or invalid # of sheets.');
        for i:=1 to SignCount do
        begin
            LineLength[i]:=book.WorkSheets[i].Cells[1,4].Value;
            x:=book.WorkSheets[i].Cells[2,4].Value;
            LineCount[i]:=x;
            LinePause[i]:=book.WorkSheets[i].Cells[3,4].Value;
            for j:=1 to x do
            begin
                for col:=1 to 4 do
                begin
                LineData[i,j,col]:='';
                LineAlign[i,j,col]:=XlHAlignRight;
                try
                    LineData[i,j,col]:=book.WorkSheets[i].Cells[3+j,col].Value;
                    LineAlign[i,j,col]:=book.WorkSheets[i].Cells[3+j,col].HorizontalAlignment;
                except
                end;
                end;
            end;
        end;

    except
        on E:Exception do
        begin
            StatusBar1.Panels[1].Text:='Error: '+E.Message;
            book.Close;
            CurrentSign:=0;
            CurrentTicker:=0;
            Exit;
        end;
    end;
    book.Close;
    CurrentSign:=0;
    CurrentTicker:=0;
    StatusBar1.Panels[1].Text:='Poll Complete.';


end;

procedure TForm1.Button1Click(Sender: TObject);
begin
    Timer1.Enabled:=False;
    Button1.Enabled:=False;
    PollExcel;
    PollTicker:=SpinEdit1.Value*60;
    Timer1.Enabled:=True;
    Button1.Enabled:=True;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
    Bogus: boolean;
begin
    Bogus:=False;
    if CurrentTicker<>0 then
    begin
        Bogus:=True;
        Dec(CurrentTicker);
        StatusBar1.Panels[2].Text:=IntToStr(CurrentTicker);
    end;

    // check poll ticker
    if PollTicker=0 then
    begin
        // we are starting
        PollTicker:=SpinEdit1.Value;
    end;

    // are we going to poll?
    Dec(PollTicker);
    if PollTicker=0 then
    begin
        PollTicker:=SpinEdit1.Value;
        Timer1.Enabled:=False;
        PollExcel;
        Timer1.Enabled:=True;
    end;

    StatusBar1.Panels[0].Text:='Next Poll - '+IntToStr(PollTicker + 1)+' seconds';

    // ok, ticker down, do we have any signs?
    if SignCount=0 then Exit;

    // ok, next sign, only if the ticker zeroed out
    if not Bogus then
    begin
         Timer1.Enabled:=False;
         Inc(CurrentSign);
         if CurrentSign>SignCount then CurrentSign:=1;
         CurrentTicker:=LinePause[CurrentSign];
         SendOutData(CurrentSign);
    end;
    Timer1.Enabled:=True;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
    if Button2.Caption = 'Pause' then
    begin
        Button2.Caption := 'Go';
        Timer1.Enabled:=False;
    end
    else
    begin
        Button2.Caption := 'Pause';
        Timer1.Enabled:=True;
    end


end;

end.
